<?php

namespace App\Entity;

use App\Repository\SqrGeneratedKeyRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=SqrGeneratedKeyRepository::class)
 */
class SqrGeneratedKey
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $appPrefix;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $appRoot;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $appRootKey;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $appRootDomaine;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $appQrnumber;

    /**
     * @ORM\Column(type="integer")
     */
    private $status;

    /**
     * @ORM\Column(type="datetime")
     */
    private $dateEnregistrement;

    /**
     * @ORM\OneToMany(targetEntity=SqrGeneratedKeyDomaine::class, mappedBy="sqrGeneratedKey")
     */
    private $sqrGeneratedKeyDomaines;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->sqrGeneratedKeyDomaines = new ArrayCollection();
        date_default_timezone_set('Africa/Douala');
        $this->dateEnregistrement = new \Datetime("now"); // default date
        $this->setAppRootKey($this->Niu(9, '1234567890'));
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAppPrefix(): ?string
    {
        return $this->appPrefix;
    }

    public function setAppPrefix(string $appPrefix): self
    {
        $this->appPrefix = $appPrefix;

        return $this;
    }

    public function getAppRoot(): ?string
    {
        return $this->appRoot;
    }

    public function setAppRoot(string $appRoot): self
    {
        $this->appRoot = $appRoot;

        return $this;
    }

    public function getAppRootKey(): ?string
    {
        return $this->appRootKey;
    }

    public function setAppRootKey(string $appRootKey): self
    {
        $this->appRootKey = $appRootKey;

        return $this;
    }

    public function getAppRootDomaine(): ?string
    {
        return $this->appRootDomaine;
    }

    public function setAppRootDomaine(string $appRootDomaine): self
    {
        $this->appRootDomaine = $appRootDomaine;

        return $this;
    }

    public function getAppQrnumber(): ?string
    {
        return $this->appQrnumber;
    }

    public function setAppQrnumber(string $appQrnumber): self
    {
        $this->appQrnumber = $appQrnumber;

        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(int $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getDateEnregistrement(): ?\DateTimeInterface
    {
        return $this->dateEnregistrement;
    }

    public function setDateEnregistrement(\DateTimeInterface $dateEnregistrement): self
    {
        $this->dateEnregistrement = $dateEnregistrement;

        return $this;
    }

    /**
     * @return Collection<int, SqrGeneratedKeyDomaine>
     */
    public function getSqrGeneratedKeyDomaines(): Collection
    {
        return $this->sqrGeneratedKeyDomaines;
    }

    public function addSqrGeneratedKeyDomaine(SqrGeneratedKeyDomaine $sqrGeneratedKeyDomaine): self
    {
        if (!$this->sqrGeneratedKeyDomaines->contains($sqrGeneratedKeyDomaine)) {
            $this->sqrGeneratedKeyDomaines[] = $sqrGeneratedKeyDomaine;
            $sqrGeneratedKeyDomaine->setSqrGeneratedKey($this);
        }

        return $this;
    }

    public function removeSqrGeneratedKeyDomaine(SqrGeneratedKeyDomaine $sqrGeneratedKeyDomaine): self
    {
        if ($this->sqrGeneratedKeyDomaines->removeElement($sqrGeneratedKeyDomaine)) {
            // set the owning side to null (unless already changed)
            if ($sqrGeneratedKeyDomaine->getSqrGeneratedKey() === $this) {
                $sqrGeneratedKeyDomaine->setSqrGeneratedKey(null);
            }
        }

        return $this;
    }
}
